% disegna il frattale con Newton vettoriale
%
% parametri di ingresso
%
% lati del quadrato
%
a=-2; b=2;
plot([a b b a a],[a a b b a],'k')
hold on;
tol=.1;
%
% numero di suddivisioni
%
nstep=300;
h=(b-a)/nstep;
for i=1:nstep+1
    x=a+(i-1)*h;
    for j=1:nstep+1
        y=a+(j-1)*h;
        [sol,suc]=newtonvec([x;y],10,.001);
        if suc==0
            plot(x,y,'.k')
            break
        end
        if sol(1)> 1-tol
            plot(x,y,'.b')
        elseif sol(2)>sqrt(3)/2-tol
            plot(x,y,'.r')
        elseif sol(2)<-sqrt(3)/2+tol
            plot(x,y,'.y')
        else
            plot(x,y,'.k')
        end
    end
end