function [Itpc]=trapc(a,b,M,f,choice,varargin)
%TRAPC Formule composite del trapezio e di Gauss.
%   ITPC = TRAPC(A,B,M,FUN,CHOICE) calcola un'approssimazione dell'integrale di
%   FUN con la formula composita del trapezio (su M intervalli equispaziati) 
%   se CHOICE=1, con la formula composita di Gauss a due nodi se CHOICE=2.
%   FUN e' una function che riceve in ingresso un vettore x e restituisce 
%   un vettore reale. FUN puo' essere una inline function.
%   ITPC = TRAPC(A,B,M,FUN,CHOICE,P1,P2,...)  passa alla function FUN i parametri
%   opzionali P1,P2,... come FUN(X,P1,P2,...).  

%   A.Quarteroni,F.Saleri, Introduzione al Calcolo Scientifico, 2004

H=(b-a)/M;
switch choice	
case 1,
  x=linspace(a,b,M+1); 
  fpm=feval(f,x,varargin{:}).*ones(1,M+1); 
  fpm(2:end-1)=2*fpm(2:end-1); 
  Itpc=0.5*H*sum(fpm);
case 2,
  z=linspace(a,b,M+1); 
  x=z(1:end-1)+H/2*(1-1/sqrt(3)); 
  x=[x, x+H/sqrt(3)]; 
  fpm=feval(f,x,varargin{:}).*ones(1,2*M); 
  Itpc=0.5*H*sum(fpm);
otherwise
  disp('Formula sconosciuta');
end