function [t,v]=ode2order(T,nt)
dt = T/(nt-1);
L=0.1; C=1.e-03; R=10; e=5;
alpha = 1/(1/dt^2+0.5*(L+R*C^2)/(L*C*R*dt));
beta = 2/dt^2-2/(L*C);
gamma = -1/dt^2+0.5*(L+R*C^2)/(L*C*R*dt);
f = e/(L*C);
v(1) = 0;
v(2) = 0;
for i = 3:nt
    v(i) = alpha*(beta*v(i-1)+gamma*v(i-2)+f);
end
t = [0:dt:T];
return