function [zero,res,niter]=newton(f,df,x0,tol,nmax,varargin)
%NEWTON Trova uno zero di una funzione.
%   ZERO=NEWTON(FUN,DFUN,X0,TOL,NMAX) approssima lo zero ZERO della 
%   funzione FUN, continua e derivabile, piu' vicino a X0 usando il metodo di     
%   Newton. FUN e la sua derivata DFUN accettano in ingresso uno scalare x e  
%   restituiscono un valore scalare. Se la ricerca dello zero fallisce, il
%   programma restituisce un messaggio d'errore. FUN e DFUN possono essere
%   inline functions. 
%   ZERO=NEWTON(FUN,DFUN,X0,TOL,NMAX,P1,P2,...) passa i parametri 
%   P1,P2,... alle funzioni FUN(X,P1,P2,...) e DFUN(X,P1,P2,...).
%   [ZERO,RES,NITER]= NEWTON(FUN,...) restituisce il valore del residuo RES
%   in ZERO ed il numero di iterazioni NITER necessario per calcolare ZERO.
x = x0; 
fx = feval(f,x,varargin{:}); 
dfx = feval(df,x,varargin{:});
niter = 0; 
diff = tol+1;
while diff >= tol & niter <= nmax
   niter = niter + 1;   
   diff = - fx/dfx;
   x = x + diff;        
   diff = abs(diff);
   fx = feval(f,x,varargin{:});        
   dfx = feval(df,x,varargin{:});
end
if niter > nmax
    fprintf(['newton si e'' arrestato senza aver soddisfatto l''accuratezza richiesta',...
    'avendo raggiunto il massimo numero di iterazioni\n']);
end
zero = x; res = fx;