function Imp=midpointc(a,b,M,f,varargin)
%MIDPOINTC Formula composita del punto medio.
%   IMP = MIDPOINTC(A,B,M,FUN) calcola una approssimazione dell'integrale 
%   della funzione FUN tramite la formula composita del punto medio (su M 
%   intervalli equispaziati). FUN e' una function che riceve in ingresso un vettore x 
%   e restituisce  un vettore reale. FUN puo' essere una inline function.
%   IMP = MIDPOINT(A,B,M,FUN,P1,P2,...) passa alla function FUN i parametri
%   opzionali P1,P2,... come FUN(X,P1,P2,...). 

%   A.Quarteroni,F.Saleri, Introduzione al Calcolo Scientifico, 2004

H=(b-a)/M; 
x = linspace(a+H/2,b-H/2,M); 
fmp=feval(f,x,varargin{:}).*ones(1,M);
Imp=H*sum(fmp);

return