function A=lu_gauss(A)
%LU_GAUSS     Fattorizzazione LU senza pivoting
%   A = LU_GAUSS(A) calcola la fattorizzazione LU di Gauss della matrice
%   A memorizzando nella parte triangolare inferiore stretta di A la matrice L (gli
%   elementi diagonali di L sono tutti uguali a 1) ed in quella superiore il fattore U

%   A.Quarteroni,F.Saleri, Introduzione al Calcolo Scientifico, 2004

[n,m]=size(A);
if n ~= m; error('A non e'' una matrice quadrata'); else
 for k = 1:n-1 
   for i = k+1:n
     A(i,k) = A(i,k)/A(k,k);
     if A(k,k) == 0, error('Un elemento pivot si e' annullato'); end
     for j = k+1:n  
       A(i,j) = A(i,j) - A(i,k)*A(k,j);
     end
   end
 end
end
return