function [t,y]=feuler(odefun,tspan,y,Nh,varargin)
%FEULER  Risolve equazioni differenziali usando il metodo di Eulero in avanti.
%   [T,Y] = FEULER(ODEFUN,TSPAN,Y0,NH) with TSPAN = [T0 TFINAL] 
%   integra il sistema di equazioni differenziali y' = f(t,y) dal  
%   tempo T0 a TFINAL con condizione iniziale Y0 usando il metodo di Eulero
%   in avanti su una griglia di NH intervalli equispaziati.
%   La funzione ODEFUN(T,Y) deve ritornare un vettore colonna corrispondente
%   a f(t,y). Ogni riga dell'array soluzione Y corrispe alla soluzione calcolata
%   per il corrispondente vettore colonna T.
%   [T,Y] = FEULER(ODEFUN,TSPAN,Y0,NH,P1,P2,...) passa i parametri addizionali
%   P1,P2,... alla funzione ODEFUN come ODEFUN(T,Y,P1,P2...). 

%   A.Quarteroni,F.Saleri, Introduzione al Calcolo Scientifico, 2004

h=(tspan(2)-tspan(1))/Nh;
tt=linspace(tspan(1),tspan(2),Nh+1);
for t = tt(1:end-1)   y = [y; y(end,:) + h*feval(odefun,t,y(end,:),varargin{:})];
end 
t=tt;
return