function coeff=approxcos(x,y,gamma,z)
% x,y vettori colonna

%approx = a0*phi0 + a1*phi1+a2*phi2
%[0,2*pi] --> [x(1),x(end)]

% 
% t = alpha*x + beta
% 
% t(x(1)) = alpha*x(1) + beta = 0
% t(x(end)) = alpha*x(end) + beta = 2*pi
% 
% beta = -alpha*x(1)
% 
% alpha*x(end) -alpha*x(1) = 2*pi
% 
% alpha = 2*pi/(x(end)-x(1))

period = pi/2;
t = period/(x(end)-x(1))*x - period/(x(end)-x(1))*x(1)
phi0 = 1+0.*x;
phi1 = cos(t);
phi2 = cos(2*t);
phi3 = cos(3*t);
phi4 = cos(4*t);
BT = [phi0, phi1, phi2, phi3, phi4];
A = BT'*BT;
rhs = BT'*y;
coeff = A\rhs;
t = period*z/(z(end)-z(1))-period/(z(end)-z(1))*z(1);
yz = coeff(1)+coeff(2)*cos(t)+coeff(3)*cos(2*t)+coeff(4)*cos(3*t)+coeff(5)*cos(4*t);
plot(z,yz,x,y,'o')
return