function [x,niter]=aitken(phi,x0,tol,kmax)
%AITKEN Estrapolazione di Aitken
%   [ALPHA,NITER]=AITKEN(PHI,X0) calcola un'approssimazione di un punto
%   fisso ALPHA della funzione PHI a partire dal dato iniziale X0 con il
%   metodo di estrapolazione di Aitken. Il metodo si arresta dopo 100 iterazioni
%   o dopo che il valore assoluto della differenza fra due iterate consecutive
%   e' minore di 1.e-04. 
%   [ALPHA,NITER]=AITKEN(PHI,X0,TOL,KMAX) consente di definire la tolleranza
%   sul criterio d'arresto ed il numero massimo di iterazioni. 

%   A.Quarteroni,F.Saleri, Introduzione al Calcolo Scientifico, 2004

if nargin == 2
    tol = 1.e-04; kmax = 100;
elseif nargin == 3
    kmax = 100;
end

x = x0; diff = tol + 1;
niter = 0;
while niter <= kmax & diff >= tol
    gx = feval(phi,x);
    ggx = feval(phi,gx);
    xnew = (x*ggx-gx^2)/(ggx-2*gx+x);
    diff = abs(xnew-x);
    x = xnew;
    niter = niter  + 1;
end

return