function [z,uh]=vallim(a,b,N,delta,gamma,f,ua,ub)
%VALLIM Differenze finite in una dimensione.
%   [Z,UH]=VALLIM(A,B,N,DELTA,GAMMA,F,UA,UB) calcola la
%   soluzione approssimata UH con il
%   metodo delle differenze finite per il problema ai limiti
%   - u"+DELTA*u'+GAMMA*u=F con DELTA, GAMMA costanti e con
%   u(A)=UA, u(B)=UB. In Z vengono memorizzati i nodi della
%   griglia di calcolo.
%
%   Si veda anche POISSONDF.

%   Saleri Fausto 24-01-01

h = (b-a)/(N+1); 
z = [a:h:b];
e = ones(N,1);
A = spdiags([-e-0.5*h*delta 2*e+gamma*h^2 -e+0.5*h*delta], -1:1, N, N); 
x = z(2:end-1); 
f = h^2*eval(f); 
f=f';
f(1) = f(1) + ua; 
f(end) = f(end) + ub;
uh = A\f; 
uh=[ua; uh; ub];

return
