function [Itpc]=trapc(a,b,M,f,formula)
%TRAPC Metodo composito del trapezio
%   [ITPC]=TRAPC(A,B,M,F,FORMULA) calcola con il
%   metodo del trapezio composito l'integrale
%   approssimato ITPC di una funzione F in [A,B]
%   usando M sotto-intervalli.
%
%   Se FORMULA e' uguale a 1 vengono usati come nodi
%   di quadratura gli estremi di ogni sotto-intervallo,
%   se FORMULA e' uguale a 2 vengono usati come nodi
%   i nodi di Gauss.
%
%   Si veda anche PTOMEDIOC, TRAPC.

%   Saleri Fausto 23-01-01
 
H=(b-a)/M; 
switch formula
case 1,
  x=[a:H:b]; fpm=eval(f); fpm(2:end-1)=2*fpm(2:end-1); Itpc=0.5*H*sum(fpm);
case 2,
  z=[a:H:b]; x=z(1:end-1)+H/2*(1-1/sqrt(3)); x=[x, x+H/sqrt(3)]; 
  fpm=eval(f);  Itpc=0.5*H*sum(fpm); 
otherwise 
  disp('Formula inesistente');
end

return
