function [t,u]=rk2(t0,T,N,f,y0)
%RK2 Il metodo di Runge-Kutta esplicito di ordine 2.
%   [T,U]=RK2(T0,T,N,F,Y0) risolve con 
%   il metodo di Runge-Kutta esplicito di ordine 2
%   il problema di Cauchy y'(t)=F(t,y(t)) con y(T0)=Y0,
%   utilizzando N sotto-intervalli equispaziati.
%
%   Si vedano anche RK3, EULIMP, CRANKNIC, PREDCOR.

%   Saleri Fausto 24-01-01

h=(T-t0)/N; tt=[t0:h:T]; u(1)=y0;
for s=tt(1:end-1)
   t = s;
   y = u(end); k1=h*eval(f);
   t = t + h;
   y = y + k1; k2=h*eval(f);
   u = [u, u(end) + 0.5*(k1+k2)];
end
t=tt;

return
