function [x,iter]=rich_no_staz(a,b,x0,nmax,toll,P)
%RICH_NO_STAZ Metodo di Richardson per sistemi lineari
%   [X,ITER]=RICH_NO_STAZ(A,B,X0,NMAX,TOLL) risolve il sistema
%   lineare A*X=B con il metodo iterativo di Richardson 
%   non precondizionato a parametro dinamico a partire 
%   dal dato iniziale X0. 
%
%   [X,ITER]=RICH_NO_STAZ(A,B,X0,NMAX,TOLL,P) utilizza
%   la matrice P come precondizionatore.
%
%   Il metodo si arresta quando la norma 2 del residuo
%   normalizzato al residuo iniziale e' minore della
%   tolleranza TOLL o quando viene raggiunto il massimo
%   numero di iterazioni NMAX.
%
%   La soluzione approssimata viene memorizzata nel
%   vettore X, mentre in ITER viene riportato il
%   numero di iterazioni che e' stato necessario per
%   ottenerla.
%
%   Si vedano anche JACOBI, GSEIDEL.

%   Saleri Fausto 23-01-01

[n,n]=size(a);
if nargin == 5
  L = eye(n); 
  U = L; 
  P = U;
else
  [L,U]=lu(P);
end
iter = 0; 
r = b - a * x0; 
r0 = norm(r); 
err = norm (r); 
x = x0;
while err > toll & iter < nmax
  iter = iter + 1;
  z = L\r; 
  z = U\z; 
  alpha = z'*r/(z'*a*z); 
  x = x + alpha*z; 
  r = b - a * x;          
  err = norm (r) / r0;
end

return
