function [tt,u]=predcor(t0,y0,T,N,f,predictor,corrector)
%PREDCOR Metodo predictor-corrector
%   [T,U]=EULESP(T0,Y0,T,N,F,PREDICTOR,CORRECTOR) risolve 
%   con un metodo predictor-corrector il problema
%   di Cauchy y'(t)=F(t,y(t)) con y(T0)=Y0,
%   utilizzando N sotto-intervalli equispaziati.
%
%   Le stringhe PREDICTOR e CORRECTOR devono precisare
%   le funzioni che eseguono un passo del metodo predictor
%   ed un passo del metodo corrector. Ad esempio,
%   PREDICTOR='eeonestep' fissa come predictor il metodo
%   di Eulero esplicito, mentre CORRECTOR='eionestep' sceglie
%   come corrector il metodo di Eulero implicito.
%
%   Si vedano anche EEONESTEP, EIONESTEP, CNONESTEP.

%   Saleri Fausto 24-01-01

h=(T-t0)/N; 
tt=[t0:h:T]; 
u=y0; [n,m]=size(u); if n < m, u=u'; end
for t=tt(1:end-1)
   y = u(:,end); 
   fn = eval(f);
   upre = eval([predictor,'(t,y,h,fn)']);
   ucor = eval([corrector,'(t+h,y,upre,h,f,fn)']);
   u = [u, ucor];
end

return
