function [lambda,x,iter]=potenzeshift(A,x0,toll,nmax,mu)
%POTENZESHIFT Il metodo delle potenze con shift per il calcolo
%   dell'autovalore di modulo massimo della matrice A.
%   [LAMBDA,X,ITER]=POTENZESHIFT(A,X0,TOLL,NMAX,MU) calcola,
%   a partire da un dato iniziale X0, l'autovalore di 
%   modulo massimo LAMBDA ed il corrispondente 
%   autovettore X di norma 2 unitaria della matrice
%   (A-MU*I)^(-1).
%
%   Il metodo si arresta quando la differenza tra due
%   approssimazioni successive, normalizzata alla 
%   penultima approssimazione, dell'autovalore LAMBDA
%   e' inferiore in valore assoluto a TOLL o quando e'
%   stato raggiunto il numero massimo di iterazioni.
%
%   Si vedano anche EIG, CERCHIGERSH.

%   Saleri Fausto 24-01-01


[n,n]=size(A); 
[L,U]=lu(A-mu*eye(n)); 
x0 = x0/norm(x0); 
z0=L\x0; pro=U\z0;
lambda = x0'*pro;
err = toll + 1; iter = 0;
while err > toll*abs(lambda) & abs(lambda) > 0 & iter <= nmax
   x = pro; x = x/norm(x); 
   z=L\x; pro=U\z;
   lambdanew = x'*pro;
   err = abs(lambdanew - lambda);
   lambda = lambdanew;
   iter = iter + 1;
end

return
