function [lambda,x,iter]=potenze(A,x0,toll,nmax)
%POTENZE Il metodo delle potenze per il calcolo
%   dell'autovalore di modulo massimo della matrice A.
%   [LAMBDA,X,ITER]=POTENZE(A,X0,TOLL,NMAX) calcola,
%   a partire da un dato iniziale X0, l'autovalore di 
%   modulo massimo LAMBDA ed il corrispondente 
%   autovettore X di norma 2 unitaria della matrice
%   A, tali cio\e che A*X=LAMBDA*X.
%
%   Il metodo si arresta quando la differenza tra due
%   approssimazioni successive, normalizzata alla 
%   penultima approssimazione, dell'autovalore LAMBDA
%   e' inferiore in valore assoluto a TOLL o quando e'
%   stato raggiunto il numero massimo di iterazioni.
%
%   Si vedano anche EIG, CERCHIGERSH.

%   Saleri Fausto 24-01-01

x0 = x0/norm(x0); 
pro = A*x0; 
lambda = x0'*pro;
err = toll + 1; 
iter =0;
while err > toll*abs(lambda) & abs(lambda) > 0 & iter <= nmax
   x = pro; 
   x = x/norm(x); 
   pro = A*x; 
   lambda_new = x'*pro;
   err = abs(lambda_new - lambda);
   lambda = lambda_new;
   iter = iter + 1;
end

return
