function [zero,niter]=newton(f,df,x0,toll,nmax)
%NEWTON Metodo di Newton per il calcolo di
%   uno zero di una funzione scalare f=f(x).
%   [ZERO,NITER]=NEWTON(F,DF,X0,TOLL,NMAX) usa il metodo 
%   di Newton per calcolare uno zero ZERO di una funzione
%   derivabile F con derivata DF a partire dal dato 
%   iniziale X0. 
%
%   Il metodo si arresta se la differenza tra due 
%   iterate consecutive e' minore di TOLL o se viene 
%   raggiunto il massimo numero di iterazioni NMAX.
%   In NITER viene slavato il numero di iterazioni
%   necessario per avere convergenza. 

%   Saleri Fausto 23-01-01
x = x0; fx = eval(f); dfx = eval(df);
niter = 0; 
diff = toll+1; diff = abs(eval(f));
while diff >= toll & niter <= nmax
   niter = niter + 1;
   diff = - fx/dfx;
   x = x + diff;
   fx = eval(f); dfx = eval(df); diff = abs(fx);
end

zero = x;

return   
