function [A,U,Q]=lu_gaussp(A)
%LU_GAUSSP Fattorizzazione LU con pivoting per colonne.
%   [B]=LU_GAUSSP(A) memorizza nella parte inferiore
%   di B il fattore triangolare inferiore L della 
%   fattorizzazione LU di A, in quella superiore 
%   il fattore triangolare superiore U a meno delle
%   permutazione.
%
%   [L,U]=LU_GAUSS(A) memorizza in L il fattore 
%   triangolare inferiore della fattorizzazione LU
%   di A, in U quello triangolare superiore a meno 
%   della permutazione.
%
%   [L,U,Q]=LU_GAUSS(A) memorizza in L il fattore 
%   triangolare inferiore della fattorizzazione LU
%   di A, in U quello triangolare superiore, in Q
%   la matrice di permutazione tale che AQ=LU.
%

%   Saleri Fausto 23-01-01

n=max(size(A));  
Q=eye(n);
for k = 1:n
   for j = k:n
      A(k,j) = A(k,j) - sum(A(k,1:k-1).*(A(1:k-1,j))'); 
   end
   [m,im] = max(abs(A(k,k:n)));      
   im = im + k - 1;
   temp = Q(:,k);  
   Q(:,k) = Q(:,im); 
   Q(:,im) = temp;
   temp = A(:,k);  
   A(:,k) = A(:,im); 
   A(:,im) = temp;
   for i = k+1:n 
      A(i,k) = (A(i,k) - sum(A(i,1:k-1).*(A(1:k-1,k))'))/A(k,k); 
   end
end
if nargout == 3    
   U=triu(A); 
   A=eye(n)+tril(A,-1);
elseif nargout == 2 
   U=Q'*triu(A); 
   A=eye(n)+tril(A,-1); 
end

return
