function [A,U]=lu_gauss(A)
%LU_GAUSS Fattorizzazione LU senza pivoting.
%   [B]=LU_GAUSS(A) memorizza nella parte inferiore
%   di B il fattore triangolare inferiore L della 
%   fattorizzazione LU di A, in quella superiore 
%   il fattore triangolare superiore U.
%
%   [L,U]=LU_GAUSS(A) memorizza in L il fattore 
%   triangolare inferiore della fattorizzazione LU
%   di A, in U quello triangolare superiore.

%   Saleri Fausto 23-01-01

n=max(size(A));
for k = 1:n
  for j = k:n  
    A(k,j) = A(k,j) - sum(A(k,1:k-1).*(A(1:k-1,j))'); 
  end
  for i = k+1:n 
    A(i,k) = (A(i,k) - sum(A(i,1:k-1).*(A(1:k-1,k))'))/A(k,k); 
  end
end

if nargout == 2 
  U=triu(A); 
  A=eye(n)+tril(A,-1); 
end


return
