function [x,iter]=gseidel(a,b,x0,nmax,toll)
%GSEIDEL Metodo di Gauss-Seidel per sistemi lineari
%   [X,ITER]=GSEIDEL(A,B,X0,NMAX,TOLL) risolve il sistema
%   lineare A*X=B con il metodo iterativo di Gauss-Seidel a
%   partire da un dato iniziale X0. 
%
%   Il metodo si arresta quando la norma 2 del residuo
%   normalizzato al residuo iniziale e' minore della
%   tolleranza TOLL o quando viene raggiunto il massimo
%   numero di iterazioni NMAX.
%
%   La soluzione approssimata viene memorizzata nel
%   vettore X, mentre in ITER viene riportato il
%   numero di iterazioni che e' stato necessario per
%   ottenerla.
%
%   Si vedano anche JACOBI, RICH_NO_STAZ.

%   Saleri Fausto 23-01-01

[n,n]=size(a);
iter = 0; 
r = b - a * x0; 
r0 = norm(r); 
err = norm (r); 
x = x0';
while err > toll & iter < nmax
 iter = iter + 1;
 for i=1:n
   s = sum(a(i,1:i-1).*x(1:i-1)); 
   s = s + sum(a(i,i+1:end).*x(i+1:end));
   x (i) = ( b(i) - s) / a(i,i);
 end
 r = b - a * x'; 
 err = norm (r) / r0;
end

return 
