function [t,u]=eulimp(t0,T,N,f,y0)
%EULIMP Il metodo di Eulero implicito.
%   [T,U]=EULIMP(T0,T,N,F,Y0) risolve con 
%   il metodo di Eulero implicito il problema
%   di Cauchy y'(t)=F(t,y(t)) con y(T0)=Y0,
%   utilizzando N sotto-intervalli equispaziati.
%
%   Si vedano anche EULESP, CRANKNIC, PREDCOR.
%
%   Necessita del toolbox SYMBOLIC e della function ZEROF.

%   Saleri Fausto 24-01-01

h=(T-t0)/N; 
tt=[t0:h:T]; 
u(1)=y0;
syms x;  
y = x;
for t=tt(2:end)
  fun = ['x-',num2str(h,16),'*(',char(eval(f)),')-(',num2str(u(end),16),')'];
  u = [u, zerof(fun,u(end))];
end

t=tt;

return
