function [t,u]=eulesp(t0,T,N,f,y0)
%EULESP Il metodo di Eulero esplicito
%   [T,U]=EULESP(T0,T,N,F,Y0) risolve con 
%   il metodo di Eulero esplicito il problema
%   di Cauchy (scalare o vettoriale) y'(t)=F(t,y(t)) 
%   con y(T0)=Y0, utilizzando N sotto-intervalli 
%   equispaziati.
%
%   F e' una funzione definita dall'utilizzatore
%   con sintassi F(T,Y).
%   
%   Si vedano anche EULIMP, CRANKNIC, PREDCOR.

%   Saleri Fausto 29-01-01

h=(T-t0)/N; 
tt=[t0:h:T]; 
u=y0; [n,m]=size(u); if n < m, u=u'; end
k = 1;
for t=tt(1:end-1)
     y = u(:,end);
  u = [u, y + h*eval(f)];
end

t=tt;

return
