function cerchiGersh(A)
%CERCHIGERSH Disegna i cerchi di Gershgorin.
%   CERCHIGERSH(A) disegna i cerchi di Gershgorin
%   in due finestre separate. In figura 1 vengono
%   rappresentati i cerchi riga, in figura 2 quelli
%   colonna.


%   Saleri Fausto 24-01-01
  
Abs = abs(A); 
n = max(size(A));
radii = sum(Abs,2)-diag(Abs);
xcenter = real(diag(A));
ycenter = imag(diag(A));
theta = [0:pi/100:2*pi];
costheta = cos(theta); 
sintheta = sin(theta); 
x=[]; 
y=[]; 
figure(1); 
clf; 
axis equal;  
hold on; 
for i = 1:n
  x = [x; radii(i)*cos(theta)+xcenter(i)];
  y = [y; radii(i)*sin(theta)+ycenter(i)];
  patch(x(i,:),y(i,:),'red')
end
for i = 1:n
    plot(x(i,:),y(i,:),'k',xcenter(i),ycenter(i),'xk')
end
xmax = max(max(x)); 
ymax=max(max(y));
xmin = min(min(x)); 
ymin=min(min(y));
hold off
figure(2); 
clf; 
axis equal; 
hold on
radii = sum(Abs)-(diag(Abs))';
x=[]; 
y=[]; 
clf; 
axis equal; 
hold on; 
for i = 1:n
  x = [x; radii(i)*cos(theta)+xcenter(i)];
  y = [y; radii(i)*sin(theta)+ycenter(i)];
  patch(x(i,:),y(i,:),'green')
end
for i = 1:n
    plot(x(i,:),y(i,:),'k',xcenter(i),ycenter(i),'xk')
end
xmax = max(max(max(x)),xmax); 
ymax=max(max(max(y)),ymax);
xmin = min(min(min(x)),xmin); 
ymin=min(min(min(y)),ymin);
hold off
axis([xmin xmax ymin ymax]); 
figure(1)
axis([xmin xmax ymin ymax]);

return
