function [zero,niter]=bisezione(f,a,b,toll,nmax)
%BISEZIONE Metodo di bisezione per il calcolo di
%   uno zero di una funzione scalare f=f(x).
%   [ZERO,NITER]=BISEZIONE(F,A,B,TOLL,NMAX) usa il metodo 
%   di bisezione per calcolare uno zero ZERO di una funzione
%   continua F in [A,B] con F(A)*F(B)<0. 
%
%   Il metodo si arresta se l'intervallo di ricerca
%   ha una lunghezza inferiore a TOLL o se viene 
%   raggiunto il massimo numero di iterazioni NMAX.
%   In NITER viene slavato il numero di iterazioni
%   necessario per avere convergenza. 

%   Saleri Fausto 23-01-01

x = [a, (a+b)*0.5, b]; fx = eval(f); 
niter = 0; I = (b - a)*0.5; 
while I >= toll & niter <= nmax
   niter = niter + 1;
   sign(fx)
   if sign(fx(1))*sign(fx(2)) < 0
      x(3) = x(2); x(2) = x(1)+(x(3)-x(1))*0.5; 
      fx = eval(f); I = (x(3)-x(1))*0.5;
   elseif sign(fx(2))*sign(fx(3)) < 0
      x(1) = x(2); x(2) = x(1)+(x(3)-x(1))*0.5;
      fx = eval(f); I = (x(3)-x(1))*0.5;
   else
      x(find(fx==0))
      x(2) = x(find(fx==0)); I = 0;
   end
end

zero = x(2);

return   
   
